/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core.ui.views;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.index.core.ui.IndexUiActivator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProvider<T> {
    private List<T> processors;

    protected void addProcessor(T processor) {
        if (this.processors == null) {
            this.processors = new ArrayList<T>();
        }
        this.processors.add(processor);
    }

    public abstract String getAttributeName();

    public String getElementName() {
        return "contributor";
    }

    public String getExtensionPointId() {
        return "indexViewContributors";
    }

    public String getPluginId() {
        return "com.aptana.index.core.ui";
    }

    public List<T> getProcessors() {
        if (this.processors == null) {
            this.processors = new ArrayList<T>();
            this.loadExtension();
        }
        return this.processors;
    }

    protected void loadExtension() {
        EclipseUtil.processConfigurationElements((String)this.getPluginId(), (String)this.getExtensionPointId(), (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                try {
                    Object instance = element.createExecutableExtension(AbstractProvider.this.getAttributeName());
                    AbstractProvider.this.processors.add(instance);
                }
                catch (CoreException e) {
                    String message = MessageFormat.format("Unable to create executable extension while processing attribute {0} on element {1} for the {2} extension point in the {3} plugin", AbstractProvider.this.getAttributeName(), element.getName(), AbstractProvider.this.getExtensionPointId(), AbstractProvider.this.getPluginId());
                    IdeLog.logError((Plugin)IndexUiActivator.getDefault(), (String)message, (Throwable)e);
                }
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{AbstractProvider.this.getElementName()});
            }
        });
    }
}

